/**
 * toolbar_code.js – MSFS 2024 Toolbar Panel Registration
 * ========================================================
 * Registriert das Lotsenradar-Panel als Toolbar-Icon in MSFS 2024.
 * Coherent GT kompatibel (kein ES6-Modul).
 */
(function () {

    var PANEL_ID = "PANEL_LOTSENRADAR_ATC";

    function Initialize() {
        var toolbar = document.querySelector('ui-panel');
        if (!toolbar) {
            toolbar = document.querySelector('tool-bar');
        }
        if (!toolbar) {
            console.warn("[LotsenradarATC] Toolbar element not found");
            return;
        }

        if (toolbar.m_toolbarListener) {
            // MSFS 2024 SU2+ toolbar API
            toolbar.m_toolbarListener.onPanelActiveChange(function (panelID, state) {
                if (panelID === PANEL_ID) {
                    console.log("[LotsenradarATC] Panel active: " + state);
                    if (typeof window._lotsenradarSetPolling === "function") {
                        window._lotsenradarSetPolling(state);
                    }
                }
            });
        } else if (toolbar.m_listener) {
            // Legacy toolbar API
            toolbar.m_listener.on("SetInGamePanelVisible", function (panelID, visible, minimized) {
                if (panelID === PANEL_ID) {
                    console.log("[LotsenradarATC] Panel visible: " + visible);
                    if (typeof window._lotsenradarSetPolling === "function") {
                        window._lotsenradarSetPolling(visible);
                    }
                }
            });
        }

        console.log("[LotsenradarATC] Toolbar initialized");
    }

    // Wait for Coherent GT to be ready
    var checkInterval = setInterval(function () {
        if (typeof Coherent !== 'undefined') {
            console.log("[LotsenradarATC] Coherent initialization completed");
            clearInterval(checkInterval);
        } else {
            console.log("[LotsenradarATC] Waiting for Coherent...");
        }
    }, 1000);

    // MSFS 2024 SU2+ legacy init pattern
    (function () {
        if (typeof window.legacyInit === "function") {
            window.legacyInit().then(function () {
                console.log("[LotsenradarATC] Legacy UI initialization for MSFS2024 SU2+ completed");
                Initialize();
            });
        } else {
            // Fallback: try after DOM ready
            if (document.readyState === "complete" || document.readyState === "interactive") {
                Initialize();
            } else {
                document.addEventListener("DOMContentLoaded", Initialize);
            }
        }
    })();

    // ── MSFS SimVar Bridge (optional, für zukünftige Erweiterungen) ─────
    window._msfsGetSimVar = function (name, unit) {
        if (typeof SimVar !== "undefined" && SimVar.GetSimVarValue) {
            try {
                return SimVar.GetSimVarValue(name, unit);
            } catch (e) {
                return null;
            }
        }
        return null;
    };

    window._msfsSetSimVar = function (name, unit, value) {
        if (typeof SimVar !== "undefined" && SimVar.SetSimVarValue) {
            try {
                SimVar.SetSimVarValue(name, unit, value);
                return true;
            } catch (e) {
                return false;
            }
        }
        return false;
    };

    console.log("[LotsenradarATC] toolbar_code.js loaded");
})();
